IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_TRILHO_PROD_FORN_ATENDIMENTO]'))
DROP VIEW [dbo].[V_TRILHO_PROD_FORN_ATENDIMENTO]
GO 
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[V_TRILHO_PROD_FORN_ATENDIMENTO]
WITH ENCRYPTION AS
SELECT --TOP 100 PERCENT 
	E.CD_EMP, 
	E.CD_FILIAL AS FILIAL_ORIG, 
	N.CD_FORN AS CD_FORN, 
	E.CD_EXCESSO_MAQ,
	SUM (N.NECESSIDADE ) NECESSIDADE,

	SUM (CASE WHEN E.EXCESSO > N.NECESSIDADE THEN
			N.NECESSIDADE
		WHEN E.EXCESSO < N.NECESSIDADE THEN
			E.EXCESSO
		ELSE
			N.NECESSIDADE 
	END) QT_ATEND,

	(SUM(CASE WHEN E.EXCESSO > N.NECESSIDADE THEN
				N.NECESSIDADE
			WHEN E.EXCESSO < N.NECESSIDADE THEN
				E.EXCESSO
			ELSE
				N.NECESSIDADE 
			END)/ SUM(NECESSIDADE)) * 100.000 AS PERC_ATEND,

	SUM(CASE WHEN E.EXCESSO > NECESSIDADE THEN NECESSIDADE  
			WHEN  E.EXCESSO < NECESSIDADE THEN E.EXCESSO
			ELSE N.NECESSIDADE  END  * N.VLR_CUSTO) VLR_ATEND

FROM         
	dbo.TRILHO_MAQ_EXCESSO AS E 
	INNER JOIN dbo.V_TRILHO_PROD_FORN AS N ON 
	E.CD_EMP  = N.CD_EMP AND
	E.DT_MOV  = N.DT_MOV AND 
    E.CD_PROD = N.CD_PROD

WHERE     
	E.CD_EMP = 1
GROUP BY 
	E.CD_EMP, 
	E.CD_FILIAL, 
	E.CD_EXCESSO_MAQ,
	N.CD_FORN
HAVING  SUM(NECESSIDADE)>0
GO


